package CASObservatory;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class CASCameraToolCore {

	private String path;
	/**
	 * All Cameras
	 */
	private String[] lsCameras;
	private String[] lsCamerasFilename;
	/**
	 * Single Camera Data
	 */
	private String CameraName;
	private String CameraFitsHeaderGain;
	private String CameraFitsHeaderTemp;
	private double lsGain[];
	private double lsReadNoise[];
	//temperature dark current model
	private boolean hasTemp = false;
	private double m_a, m_b,m_c; // a exp(bx) + c 
	public CASCameraToolCore() {

	}

	public String[] getCameras() {
		return lsCameras;
	}

	public String[] getCamerasFilename() {
		return lsCamerasFilename;
	}

	public void setCameraPath(String path) {
		this.path = path;
	}

	public boolean hasHeader() {
		return !CameraFitsHeaderGain.isEmpty();
	}
	public boolean hasTemp() {
		return hasTemp;
	}

	public String getHeaderGain() {
		return CameraFitsHeaderGain;
	}

	public String getHeaderTemp() {
		return CameraFitsHeaderTemp;
	}

	public String getCameraName() {
		return CameraName;
	}

	public double getGain(double x) {

		if (x < lsGain[0]) {
			System.out.println("getGain - Out of Array");
			return lsGain[1];
		}
		if (x > lsGain[lsGain.length - 2]) {
			System.out.println("getGain -  Out of Array");
			return lsGain[lsGain.length - 1];
		}

		double[] p = getRange(x, 1);

		return f(x, p[0], p[1], p[2], p[3]);
	}

	public boolean checkInputGain(double x) {	        
		if (x < lsGain[0] || x > lsGain[lsGain.length - 2])
			return false;
		return true;

	}

	public String getRangeInfo() {
		String res = "";
		res = "Gain Interval is: [ " + String.valueOf(lsGain[0]);
		res += " , " + String.valueOf(lsGain[lsGain.length - 2]) + " ]";
		return res;
	}

	public double getDarkCurrent(double temp) {
        // y = a exp(bx)
		return m_a*Math.exp(m_b*temp) + m_c;
	}

	public double getReadNoise(double x) {
		if (x < lsReadNoise[0]) {
			System.out.println("getReadNoise - Out of Array");
			return lsReadNoise[1];
		}
		if (x > lsReadNoise[lsReadNoise.length - 2]) {
			System.out.println("getReadNoise -  Out of Array");
			return lsReadNoise[lsReadNoise.length - 1];
		}
		double[] p = getRange(x, 2);
		return f(x, p[0], p[1], p[2], p[3]);
	}

	// zwei punkte form geradengleichung
	private double f(double x, double x1, double y1, double x2, double y2) {
		// System.out.println(x1 + "\t" + y1 + "\t" + x2 + "\t" + y2);
		return (y2 - y1) / (x2 - x1) * (x - x1) + y1;
	}

	private double[] getRange(double x, int type) {
		double[] res = new double[4];
		// type == 1 -> GAIN
		if (type == 1) {
			int len = lsGain.length;
			int pos = 0;
			for (int i = 0; i < len; i = i + 2) {
				if (x > lsGain[i])
					pos = i;
			}
			res[0] = lsGain[pos];
			res[1] = lsGain[pos + 1];
			res[2] = lsGain[pos + 2];
			res[3] = lsGain[pos + 3];

		}
		// type == 2 -> NOISE
		if (type == 2) {

			int len = lsReadNoise.length;
			int pos = 0;
			for (int i = 0; i < len; i = i + 2) {
				if (x > lsReadNoise[i])
					pos = i;
			}
			res[0] = lsReadNoise[pos];
			res[1] = lsReadNoise[pos + 1];
			res[2] = lsReadNoise[pos + 2];
			res[3] = lsReadNoise[pos + 3];
		}

		return res;
	}

	/**
	 * Read all Cameras Files (camera_) in the directory given by path. The method
	 * provide then the arrays: lsCameras and lsCameraFilename.
	 */
	public void readCameras() {

		List<String> res = new ArrayList<String>();
		File[] files = new File(path).listFiles();
		// step
		for (File file : files) {
			if (file.isFile()) {
				String name = file.getName();
				if (name.startsWith("camera_"))
					res.add(file.getName());
			}
		}
		// step
		int len = res.size();
		lsCameras = new String[len];
		lsCamerasFilename = new String[len];

		for (int i = 0; i < len; i++) {
			String fileName = res.get(i);
			lsCamerasFilename[i] = fileName;
			String pathFile = path + fileName;
			List<String> liste = readFile(pathFile);
			prepare(liste); // CAMERA and Header_Gain
			lsCameras[i] = CameraName;

		}
	}

	private String getFilePath(String cameraName) {
		String res = "";
		for (int i = 0; i < lsCameras.length; i++) {
			if (cameraName == lsCameras[i]) {
				res = lsCamerasFilename[i];
				break;
			}
		}
		return path + res;
	}

	/**
	 * Read a Single Camera
	 * 
	 * @param filePath
	 */
	public void prepareCamera(String cameraName) {

		String filePath = getFilePath(cameraName);
		List<String> liste = readFile(filePath);
		prepare(liste); // CAMERA and Header_Gain
		lsGain = getArray(liste, "GAIN");
		lsReadNoise = getArray(liste, "READ_NOISE");
	}

	/***
	 * 
	 * @param lsString
	 * @param TYP      GAIN or READ_NOISE
	 * @return double Array of all Points(x1,y1,x2,y2,....) of the given TYPE.
	 */
	private double[] getArray(List<String> lsString, String TYP) {

		String strTmp = "";
		for (int i = 0; i < lsString.size(); i++) {
			String str = lsString.get(i);
			if (str.startsWith(TYP)) {
				String tmp[] = str.split("=");
				if (tmp.length == 2)
					strTmp = tmp[1].trim();
			}
		}

		String liste[] = strTmp.split(",");
		double res[] = new double[liste.length];
		for (int i = 0; i < res.length; i++)
			res[i] = Double.valueOf(liste[i]);

		return res;
	}

	private void prepare(List<String> lsString) {
		hasTemp=false;
	    
		
		for (int i = 0; i < lsString.size(); i++) {
		
			

			String str = lsString.get(i);			
			if (str.startsWith("CAMERA")) {
				String tmp[] = str.split("=");
				if (tmp.length == 2)
					CameraName = tmp[1].trim();
			}
			if (str.startsWith("HEADER_GAIN")) {
				CameraFitsHeaderGain = ""; // no header
				String tmp[] = str.split("=");
				if (tmp.length == 2)
					CameraFitsHeaderGain = tmp[1].trim();
			}
			if (str.startsWith("HEADER_TEMP")) {
				CameraFitsHeaderTemp = ""; // no header
				String tmp[] = str.split("=");
				if (tmp.length == 2) {
					CameraFitsHeaderTemp = tmp[1].trim();
					hasTemp = true;
				}

			}
			if (hasTemp) {
				//System.out.println("read temp");
				
				if (str.startsWith("TEMP_A")) {
					String tmp[] = str.split("=");
					if (tmp.length == 2) {
						String strA = tmp[1].trim();
						m_a = Double.valueOf(strA);
					}
				}
				if (str.startsWith("TEMP_B")) {
					String tmp[] = str.split("=");
					if (tmp.length == 2) {
						String strB = tmp[1].trim();
						m_b = Double.valueOf(strB);
					}
				}
				if (str.startsWith("TEMP_C")) {
					String tmp[] = str.split("=");
					if (tmp.length == 2) {
						String strC = tmp[1].trim();
						m_c = Double.valueOf(strC);
					}
				}
				
			}
		}
	}

	private List<String> readFile(String pathFile) {
		List<String> lsFile = new ArrayList<String>();
		File file = new File(pathFile);
		try {
			Scanner scanner = new Scanner(file);
			while (scanner.hasNextLine()) {
				String line = scanner.nextLine();
				line = line.trim();
				if (!line.isEmpty() && !line.startsWith("#"))
					lsFile.add(line.trim());
			}
			scanner.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return lsFile;
	}

}
