package CASObservatory;

import javax.swing.JDialog;
import ij.plugin.PlugIn;

/*
 * 
 * ExampleFile: camera_xxx.dat
 * 
 * #
 * # CAMERA: The Name of the Camera
 * # HEADER_GAIN: Header Name of GAIN, if provided from the camera-software!
 *                otherwise let this value empty (HEADER_GAIN=)
 * # GAIN       = List of x,y Pairs
 * # READ_NOISE = List of x,y Pairs
 * #
 * # HEADER_TEMP: Header Name of TEMP, if provided from the camera-software!
 *                otherwise let this value empty (HEADER_TEMP=)
 * # model: y = a exp(bx) + c
 * TEMP_A= value of a (double)
 * TEMP_B= value of b (double)
 * TEMP_C= value of c (double)
 *
 * CAMERA=ZWO ASI 178 mm cool
 * HEADER_GAIN= GAIN
 * GAIN=0,0.9,50,0.5,100,0.28,150,0.2,200,0.12,235,0.8,300,0.4,400,0.2
 * READ_NOISE=0,2.2,50,1.91,100,1.74,150,1.59,200,1.47,235,1.41,300,1.42,400,1.4
 * HEADER_TEMP= CCD-TEMP
 * TEMP_A=
 * TEMP_B=
 * 
 */

public class Camera_Tool implements PlugIn {

	static int running = 0;

	@Override
	public void run(String arg) {
		if (running == 0) {
			CASCameraToolDialog dialog = new CASCameraToolDialog();
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
			running = 1;
		}
	}
}