#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Apr 13 19:16:13 2023
Plugin CameraTool used to get the Values:
    TEMP_A
    TEMP_B
    TEMP_C
    for the model:   a exp(bx) + c
    to calculate the darkcurrent /pix/s
    The Values must be readout from a given datasheet. Use the list xs/ys this script will then calculate a,b,c.

@author: torsten
"""
import numpy as np
import scipy.optimize
import matplotlib.pyplot as plt

# show statistic
stat=True

### x/y values given from datasheet

#
# ASI 2600  (value/2)*skala   mit skale [1,1.1,...,2]
#
##xs = np.array([-20.0,-15.0,-10.0,-5.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0,30.0])
##ys = np.array([0.000123,0.00024,0.00049,0.00099,0.00196,0.00392,0.00781, 0.01703125,  0.03173, 0.06252,0.125])

#
# ASI 178 mono cool
#
xs = np.array([-20.0,-15.0,-10.0,-5.0, 0.0, 5.0, 10.0])
ys = np.array([0.0058,0.0067,0.007,0.0085,0.0096,0.0138,0.0204])


plt.plot(xs, ys, '.')
plt.title("Original Data")
# =============================================================================
# 
def monoExp(x, a, b, c):
     return a* np.exp(b* x) +c
# perform the fit
p0 = (0.00123, 1, 0) # start with values near those we expect
params, cv = scipy.optimize.curve_fit(monoExp, xs, ys, p0)
a, b, c = params
sampleRate = 20_000 # Hz
tauSec = (1 / b) / sampleRate
# 
# # determine quality of the fit
squaredDiffs = np.square(ys - monoExp(xs, a, b, c))
squaredDiffsFromMean = np.square(ys - np.mean(ys))
rSquared = 1 - np.sum(squaredDiffs) / np.sum(squaredDiffsFromMean)


if stat:
    print(f"R² = {rSquared}")
    print(f"Y = {a} * e^({b} * x) + {c}")
    print(f"Tau = {tauSec * 1e6} µs")

# 
# plot the results
plt.plot(xs, ys, '.', label="data")
plt.plot(xs, monoExp(xs, a, b, c), '--', label="fitted")
plt.title("DarkCurrent - Fitted Exponential Curve")

print("\n")
print("a exp(bx) + c")
print("-------------- COPY KAMERA SETTINGS ---------------")
print("TEMP_A =",a)
print("TEMP_B =",b)
print("TEMP_C =",c)
# =============================================================================
print("Check values ....")
print(monoExp(-10,a,b,c))
print(monoExp(10,a,b,c))