package CASObservatory;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

/**
 * 
 * @author torsten
 *
 */
public class CASCameraToolDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	private String titleVersion = "CASObservatory - Camera Tool  v0.1.5";
	private final JPanel contentPanel = new JPanel();

	private JTextField ctrlGainValue;
	private JTextField ctrlTempValue;
	private JTextField ctrlGain;
	private JTextField ctrlNoise;
	private JTextField ctrlDarkCurrent;

	private JComboBox<String> ctrlComboBox;
	private JCheckBox ctrlCheckBox;
	private JButton ctrlFitsHeader;
	private JLabel ctrlStatus;

	private CASCameraToolCore cameraTool;
	private CASFitsReader reader;

	private ImagePlus img;
	String dir;
	String file;
	String path;
	String pluginPath = "/plugins/CASObservatory/";

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		try {
			CASCameraToolDialog dialog = new CASCameraToolDialog();
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Create the dialog.
	 */
	public CASCameraToolDialog() {
		setResizable(false);
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosed(WindowEvent e) {
				Camera_Tool.running = 0;
				dispose();
			}
		});

		path = System.getProperty("user.dir") + pluginPath;
		setTitle(titleVersion);

		setBounds(100, 100, 446, 428);
		getContentPane().setLayout(null);
		contentPanel.setBounds(0, 12, 440, 344);
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel);
		contentPanel.setLayout(null);
		{
			JLabel lblNewLabel = new JLabel("Input");
			lblNewLabel.setForeground(new Color(0, 0, 255));
			lblNewLabel.setBounds(12, 12, 70, 15);
			contentPanel.add(lblNewLabel);
		}
		{
			ctrlCheckBox = new JCheckBox("Read Fits Header");
			ctrlCheckBox.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					boolean state = ctrlCheckBox.isSelected();
					ctrlFitsHeader.setEnabled(state);
				}
			});
			ctrlCheckBox.setBounds(110, 70, 247, 23);
			contentPanel.add(ctrlCheckBox);
		}
		{
			ctrlNoise = new JTextField();
			ctrlNoise.setBounds(303, 241, 114, 19);
			contentPanel.add(ctrlNoise);
			ctrlNoise.setColumns(10);
		}
		{
			JLabel lblNewLabel_2 = new JLabel("Output");
			lblNewLabel_2.setForeground(new Color(0, 0, 255));
			lblNewLabel_2.setBounds(12, 186, 70, 15);
			contentPanel.add(lblNewLabel_2);
		}
		{
			JLabel lblNewLabel_3 = new JLabel("Gain                    (e-/ADU)");
			lblNewLabel_3.setBounds(12, 213, 262, 17);
			contentPanel.add(lblNewLabel_3);
		}
		{
			JLabel lblNewLabel_1 = new JLabel("Camera");
			lblNewLabel_1.setBounds(12, 44, 70, 15);
			contentPanel.add(lblNewLabel_1);
		}
		{
			ctrlComboBox = new JComboBox();
			ctrlComboBox.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					String name = String.valueOf(ctrlComboBox.getSelectedItem());
					cameraTool.prepareCamera(name);
					ctrlGainValue.setText("");
					ctrlTempValue.setText("");
					clear();
					manageFitsHeader();
				}
			});
			ctrlComboBox.setBounds(110, 39, 317, 24);
			contentPanel.add(ctrlComboBox);
		}
		{
			JLabel lblNewLabel_4 = new JLabel("Gain Value");
			lblNewLabel_4.setBounds(12, 104, 108, 15);
			contentPanel.add(lblNewLabel_4);
		}
		{
			ctrlGainValue = new JTextField();
			ctrlGainValue.setBounds(110, 102, 114, 19);
			contentPanel.add(ctrlGainValue);
			ctrlGainValue.setColumns(10);
		}
		{
			JButton ctrlCalculateGain = new JButton("");
			ctrlCalculateGain.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					onButtonGain();
				}
			});
			ctrlCalculateGain.setBounds(392, 102, 35, 19);
			ctrlCalculateGain.setIcon(new ImageIcon(path + "res/reload.png"));

			contentPanel.add(ctrlCalculateGain);
		}
		{
			ctrlGain = new JTextField();
			ctrlGain.setBounds(303, 211, 114, 19);
			contentPanel.add(ctrlGain);
			ctrlGain.setColumns(10);
		}
		{
			JLabel lblNewLabel_5 = new JLabel("Read Noise       (e/count)");
			lblNewLabel_5.setBounds(12, 242, 221, 17);
			contentPanel.add(lblNewLabel_5);
		}

		ctrlFitsHeader = new JButton("");
		ctrlFitsHeader.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				onButtonFitsHeader();
			}
		});
		ctrlFitsHeader.setIcon(new ImageIcon(path + "res/reload.png"));
		ctrlFitsHeader.setBounds(392, 72, 35, 19);
		contentPanel.add(ctrlFitsHeader);
		{
			JLabel lblStatus = new JLabel("Status:");
			lblStatus.setBounds(12, 301, 70, 15);
			contentPanel.add(lblStatus);
		}
		{
			ctrlStatus = new JLabel("");
			ctrlStatus.setForeground(new Color(245, 121, 0));
			ctrlStatus.setBounds(104, 301, 323, 15);
			contentPanel.add(ctrlStatus);
		}

		JLabel lblNewLabel_4 = new JLabel("Temp. Value");
		lblNewLabel_4.setBounds(12, 133, 108, 15);
		contentPanel.add(lblNewLabel_4);

		ctrlTempValue = new JTextField();
		ctrlTempValue.setColumns(10);
		ctrlTempValue.setBounds(110, 131, 114, 19);
		contentPanel.add(ctrlTempValue);

		JButton ctrlCalculateTemp = new JButton("");
		ctrlCalculateTemp.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				onButtonTemp();
			}

		});
		ctrlCalculateTemp.setBounds(392, 128, 35, 19);
		ctrlCalculateTemp.setIcon(new ImageIcon(path + "res/reload.png"));
		contentPanel.add(ctrlCalculateTemp);
		{
			JLabel lblNewLabel_5 = new JLabel("Dark Current     (e/pix/s)");
			lblNewLabel_5.setBounds(12, 272, 221, 17);
			contentPanel.add(lblNewLabel_5);
		}
		{
			ctrlDarkCurrent = new JTextField();
			ctrlDarkCurrent.setColumns(10);
			ctrlDarkCurrent.setBounds(303, 272, 114, 19);
			contentPanel.add(ctrlDarkCurrent);
		}
		{
			JButton ctrlQuit = new JButton("Quit");
			ctrlQuit.setBounds(320, 368, 114, 25);
			getContentPane().add(ctrlQuit);
			ctrlQuit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Camera_Tool.running = 0;
					dispose();
				}
			});
		}

		init();
	}

	private void init() {

		cameraTool = new CASCameraToolCore();
		cameraTool.setCameraPath(path + "res/");
		cameraTool.readCameras();
		fillCombo();
	}

	public void fillCombo() {
		ctrlComboBox.removeAllItems();
		String ls[] = cameraTool.getCameras();
		for (int i = 0; i < ls.length; i++) {
			ctrlComboBox.addItem(ls[i]);
		}
	}

	private void onButtonTemp() {
		String text = ctrlTempValue.getText();
		String name = String.valueOf(ctrlComboBox.getSelectedItem());
		cameraTool.prepareCamera(name);
		if (!cameraTool.hasTemp()) {
			ctrlStatus.setText("Darkcurrent not provided!");
			return;
		}
		ctrlStatus.setText("");

		try {
			double temp = Double.valueOf(text);
			System.out.println(temp);
			ctrlStatus.setText("");
			if (temp < -50 || temp > 50) {
				ctrlStatus.setText("Temperature Interval is: [-50,50]");
				clear();
			}

			else {
				calculateDarkcurrent(temp);
			}

		} catch (NumberFormatException e) {
			ctrlStatus.setText("Wrong Format Number Expected!");
			clear();
		}
	}

	private void onButtonGain() {

		String text = ctrlGainValue.getText();
		String name = String.valueOf(ctrlComboBox.getSelectedItem());
		cameraTool.prepareCamera(name);

		try {
			double gain = Double.valueOf(text);
			System.out.println(gain);
			ctrlStatus.setText("");
			if (!cameraTool.checkInputGain(gain)) {
				System.out.println("gain not supported!");
				ctrlStatus.setText(cameraTool.getRangeInfo());
				clear();
			}

			else {
				calculateGainAndNoise(gain);
			}

		} catch (NumberFormatException e) {
			ctrlStatus.setText("Wrong Format Number Expected!");
			clear();
		}

	}

	private void clear() {
		ctrlGain.setText("");
		ctrlNoise.setText("");
		ctrlDarkCurrent.setText("");

	}

	private void enableHeader(boolean value) {
		ctrlCheckBox.setEnabled(value);
		ctrlFitsHeader.setEnabled(value);
	}

	private void calculateDarkcurrent(double temp) {
		double d = cameraTool.getDarkCurrent(temp);
		DecimalFormat df = new DecimalFormat("#.#####");
		String strD = df.format(d);
		ctrlDarkCurrent.setText(strD);
	}

	private void calculateGainAndNoise(double gain) {

		double g = cameraTool.getGain(gain);
		double n = cameraTool.getReadNoise(gain);
		DecimalFormat df = new DecimalFormat("#.#####");
		String strG = df.format(g);
		String strN = df.format(n);

		ctrlGain.setText(strG);
		ctrlNoise.setText(strN);
	}

	/**
	 * 
	 * @return true when an image is open and the fits-header has a gain entry,
	 *         otherwise the return value will be false.
	 */
	private boolean manageFitsHeader() {

		// step 0: image open?
		int[] wList = WindowManager.getIDList();
		if (wList == null) {
			dir = "";
			file = "";
			enableHeader(false);
			return false;
		}

		// step 1: Fits-Header?
		String name = String.valueOf(ctrlComboBox.getSelectedItem());
		cameraTool.prepareCamera(name);
		if (cameraTool.hasHeader()) {
			enableHeader(true);
			return true;
		}
		// step 2: no valid Fits-Header!
		enableHeader(false);
		return false;

	}

	/**
	 * read gain value from the fits-header of the current image.
	 */
	private void onButtonFitsHeader() {

		if (!manageFitsHeader())
			return;

		img = IJ.getImage();
		FileInfo info = img.getOriginalFileInfo();
		dir = info.directory;
		file = info.fileName;
		reader = new CASFitsReader(dir, file);
		String strGAIN = cameraTool.getHeaderGain();
		String strTemp = cameraTool.getHeaderTemp();

		double gain = reader.readDoubleHeaderValue(strGAIN);
		ctrlGainValue.setText("" + gain);

		/* Temperature Model */
		if (strTemp.isEmpty())
			ctrlTempValue.setText("(unused)");
		else {
			double temp = reader.readDoubleHeaderValue(strTemp);
			ctrlTempValue.setText("" + temp);
		}

		// System.out.println("dir: " + dir);
		// System.out.println("file: " + file);

	}
}
