package CASObservatory;

import java.io.IOException;

import ij.IJ;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;

/**
 * using the nom.tam FITS library
 *
 */
public class CASFitsReader {

	Fits f;	

	public CASFitsReader(String directory, String fileName) {

		String path = directory + fileName;
		try {
			f = new Fits(path);
		} catch (FitsException e) {
			IJ.error("This does not appear to be a FITS file.");
			IJ.showStatus("");			
		}
	}

	
	public double readDoubleHeaderValue(String headerName) {
		double res = -5555;
		try {
			res = f.getHDU(0).getHeader().getDoubleValue(headerName);
		} catch (FitsException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return res;
	}
	
}
